@echo off
rem -- "_upload_file.BAT" 
rem -- Function: wraps & uploads file on target printer devices into target folder on HD; 
rem -- Usage: drag & drop file onto this BAT; (an empty 0-byte file will remove it) 

rem -------------------------------------------------------------------------------------

rem -- specify list of target device IP addresses; 
rem --   (!) surrounded by parentheses; 
rem --   Example: set $devices= ( 172.17.23.45 195.1.3.3 ) 
set $devices= ( 191.100.11.61 ) 

rem -- specify protocol to be used to send data to device (L= lpr, T= tcpsend/9100); 
rem -- If "T" is chosen, the file "tcpsend.exe" needs to reside in the same folder as this BAT. 
rem --   Example: set $protocol=L
set $protocol=T

rem -- specify target folder on device HD; 
rem --   (!) must be an immediate sub-folder of "0:\pcl"; (!) without trailing "\" nor blanks; 
rem --   (!) for convert.ini: "0:\pcl\macros" for convert v9.51 & higher; "0:\pcl\ibs" for convert v9.50 & lower; 
rem --   Example: set $folder=0:\pcl\macros
rem ... set $folder=0:\pcl\macros
rem ... 
set $folder=0:\pcl\macros

rem -- specify target file name, if different from source file name 
rem --   Example: set $fileOUTname=convert.ini
rem ... 
set $fileOUTname=convert.ini


rem -------------------------------------------------------------------------------------

set $fileINname=%~n1%~x1

if "%$fileOUTname%"=="" set $fileOUTname=%$fileINname%

set $filesize=%~z1

%~d1
cd %~p1

if "%$filesize%"=="0" goto $lbl_remove
goto $lbl_upload

:$lbl_upload

echo Wrapping file "%$fileINname%" as "%$fileOUTname%" for upload to "%$folder%" ... 

rem send prefix 
echo %%-12345X@PJL >                                                                  tmpupload.prn 
echo @PJL FSMKDIR NAME="0:\pcl" >>                                                     tmpupload.prn 
echo @PJL FSMKDIR NAME="%$folder%" >>                                                  tmpupload.prn 
echo @PJL FSDOWNLOAD FORMAT:BINARY NAME="%$folder%\%$fileOUTname%" SIZE=%$filesize% >> tmpupload.prn 

rem send file 
copy /b tmpupload.prn+"%$fileINname%"                                                  tmpupload.prn >nul 

rem send suffix
echo %%-12345X>>                                                                      tmpupload.prn 

echo Uploading file ... 
if "%$protocol%"=="L" for %%D in %$devices% do lpr -S %%D -P lp tmpupload.prn 
if "%$protocol%"=="T" for %%D in %$devices% do tcpsend %%D 9100 tmpupload.prn 

del tmpupload.prn >nul 

echo ... done. 

goto end 


:$lbl_remove

echo Removing file "%$fileOUTname%" from "%$folder%" ... 

rem send prefix 
echo %%-12345X@PJL >                                           tmpupload.prn 
echo @PJL FSDELETE NAME="%$folder%\%$fileOUTname%" >>           tmpupload.prn 

rem send suffix 
echo %%-12345X>>                                               tmpupload.prn 

echo Uploading file ... 
if "%$protocol%"=="L" for %%D in %$devices% do lpr -S %%D -P lp tmpupload.prn 
if "%$protocol%"=="T" for %%D in %$devices% do tcpsend %%D 9100 tmpupload.prn 

del tmpupload.prn >nul 

echo ... done. 

goto end 

rem -------------------------------------------------------------------------------------

:end 

rem pause

