#! /usr/bin/perl
#
#		RRRR  RRR    IIIII    CCCC      OOOO    HHH  HHH
#		RRRR  RRRR   IIIII   CCCCCC    OOOOOO   HHH  HHH
#		RRRR  RRRRR  IIIII  CCC  CCC  OOO  OOO  HHH  HHH
#		RRRR  RRRR   IIIII  CCC       OOO  OOO  HHH  HHH
#		RRRR RRRR    IIIII  CCC       OOO  OOO  HHHHHHHH
#		RRRR  RRRR   IIIII  CCC       OOO  OOO  HHH  HHH
#		RRRR   RRRR  IIIII  CCC  CCC  OOO  OOO  HHH  HHH
#		RRRR   RRRR  IIIII   CCCCCC    OOOOOO   HHH  HHH
#		RRRR   RRRR  IIIII    CCCC      OOOO    HHH  HHH
#
#		Copyright 2003 by Ricoh Europe B.V.
#
#		THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED WARRANTIES, 
#		INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
#		AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL 
#		THE RICOH EUROPE B.V. OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
#		INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
#		(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
#		LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
#		ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
#		(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF 
#		THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#		Branch		: European Development and Support Center
#		Section		: Printing & Fax Solution Group
#		Author(s)	: Yasushi (Yan) Shiba 
#
#		Project		: Barcode & OCR Package -Intelligent Version-
#		Component	: tcpsend tool 
#		Version		: 0.9.0.0	
#		Compiler		: Perl5 
#				  
#		Description:			
# 		This program sends a specified file to the specific IP address or host name
#		and TCP/IP port number. It is intended to be used in conjunction with 
#		Barcode & OCR package - Intelligent Version -, also known as IBS.
#
#     Syntax:
#		perl tcpsend.pl ip_address/hostname TCP/IP_port_no file_name
#
#		Required Environment:
#		Any UNIX environment where Perl is installed is expected to work. But it
#		is not guaranteed.
##################################################################################

if ($#ARGV == -1) { die "Please enter: perl tcpsend.pl ip_address/hostname TCP/IP_port_no file_name" }

unless ($#ARGV == 2) { die "The number of arguments must be 3. Program aborting. Actual:",$#ARGV + 1,"."}

use IO::Socket;

$PRT1 = $ARGV[0];
$PORT_NO = $ARGV[1]; 
$FILE_NAME = $ARGV[2];

$remote = IO::Socket::INET->new(
    Proto => "tcp",
    PeerAddr => $PRT1,
    PeerPort => $PORT_NO,
    Timeout => "60",
    );

unless ($remote) { die "Cannot connect to the IP address or hostname ",$PRT1,"."}
$remote->autoflush(1);

open WP, "$FILE_NAME" or die "Cannot open $FILE_NAME: $!\n";
binmode WP;
while (read WP, $buf, 1024) 
{ 
	print $remote $buf;
}
close WP;
close $remote;
